/*!
 * @file        main.h
 *
 * @brief       Header for main.c module
 *
 * @version     V1.0.0
 *
 * @date        2022-02-25
 *
 * @attention
 *
 *  Copyright (C) 2021-2022 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be usefull and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

#ifndef __MAIN_H
#define __MAIN_H

#ifdef __cplusplus
  extern "C" {
#endif

#include "Board.h"
#include "stdio.h"

#include "apm32f4xx.h"
#include "apm32f4xx_can.h"
#include "apm32f4xx_misc.h"
#include "apm32f4xx_gpio.h"
#include "apm32f4xx_usart.h"
#include "apm32f4xx_misc.h"

#if defined (APM32F407_MINI)
#define APM_LEDInit APM_MINI_LEDInit
#define APM_PBInit  APM_MINI_PBInit
#define APM_LEDOn  APM_MINI_LEDOn
#define APM_LEDOff  APM_MINI_LEDOff

#elif defined (APM32F407_ELE_HUETB)
#define APM_LEDInit APM_ELE_HUETB_LEDInit
#define APM_PBInit  APM_ELE_HUETB_PBInit
#define APM_LEDOn  APM_ELE_HUETB_LEDOn
#define APM_LEDOff  APM_ELE_HUETB_LEDOff

#elif defined (APM32F407_EVAL)
#define APM_LEDInit APM_EVAL_LEDInit
#define APM_PBInit  APM_EVAL_PBInit
#define APM_LEDOn  APM_EVAL_LEDOn
#define APM_LEDOff  APM_EVAL_LEDOff

#else
#error "Please select first the APM32 board to be used (in board.c)"
#endif

#ifdef __cplusplus
}
#endif

#endif /* __MAIN_H */
